/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Filename:
    $Workfile: EplCnPck_Public.h $

    $GlobalRev: unknown $
    $Version: V2.1.53.0 $
    $Packaged: 2015-10-26 16:18 $

   Targets:

   Description:



  Functions:


   Changes:

     Version    Date        Author   Description
     ---------------------------------------------------------------------------
    7           26.08.2008  sb      added EPLCN_DPM_SET_CONFIG_REQ request
    6           23.04.2008  sb      added field definitions for usObjAccess of EPLCN_PCK_OD_CREATE_OBJECT_REQ
    5           11.02.2008  sb      added longer warmstart packet (for adding bus-synchronous mode)
    4           05.02.2008  sb      added MSK_EPLCN_DPM_WARMSTART_STACK_CFG_USE_APP_READY_FOR_PRES_RD_FLAG
    3           29.11.2007  sb      added packet for entering resetconfiguration with change of EPL node id
    2           27.11.2007  sb      removed useless fields from packet
    1           11.10.2007  sb      created
*******************************************************************************/

#ifndef EPLCNPCK_PUBLIC_H_INCLUDED
#define EPLCNPCK_PUBLIC_H_INCLUDED


#ifndef EPLCNPCK_OBJDICT_DEFS_H
#define EPLCNPCK_OBJDICT_DEFS_H
/* Object Dictionary Definitions for access rights */
#define EPL_OD_READ_PRE_OPERATIONAL_1         0x0001
#define EPL_OD_READ_PRE_OPERATIONAL_2         0x0002
#define EPL_OD_READ_READY_TO_OPERATE          0x0004
#define EPL_OD_READ_OPERATIONAL               0x0008
#define EPL_OD_READ_STOPPED                   0x0010
#define EPL_OD_READ_BASIC_ETHERNET            0x0020
#define EPL_OD_READ_NOT_ACTIVE                0x0040
#define EPL_OD_READ_DURING_RESET              0x0080

#define EPL_OD_WRITE_PRE_OPERATIONAL_1        0x0100
#define EPL_OD_WRITE_PRE_OPERATIONAL_2        0x0200
#define EPL_OD_WRITE_READY_TO_OPERATE         0x0400
#define EPL_OD_WRITE_OPERATIONAL              0x0800
#define EPL_OD_WRITE_STOPPED                  0x1000
#define EPL_OD_WRITE_BASIC_ETHERNET           0x2000
#define EPL_OD_WRITE_NOT_ACTIVE               0x4000
#define EPL_OD_WRITE_DURING_RESET             0x8000

#define EPL_OD_READ_ALL                       0x00FF
#define EPL_OD_WRITE_ALL                      0xFF00

#define EPL_OD_ACCESS_ALL                     0xFFFF


#define EPL_OD_OBJECTCODE_VAR                 0x07
#define EPL_OD_OBJECTCODE_ARRAY               0x08
#define EPL_OD_OBJECTCODE_RECORD              0x09
#endif

#define EPL_OD_DTYPE_BOOLEAN                      0x0001
#define EPL_OD_DTYPE_INTEGER8                     0x0002
#define EPL_OD_DTYPE_INTEGER16                    0x0003
#define EPL_OD_DTYPE_INTEGER32                    0x0004
#define EPL_OD_DTYPE_UNSIGNED8                    0x0005
#define EPL_OD_DTYPE_UNSIGNED16                   0x0006
#define EPL_OD_DTYPE_UNSIGNED32                   0x0007
#define EPL_OD_DTYPE_REAL32                       0x0008
#define EPL_OD_DTYPE_VISIBLE_STRING               0x0009
#define EPL_OD_DTYPE_OCTET_STRING                 0x000a
#define EPL_OD_DTYPE_UNICODE_STRING               0x000b
#define EPL_OD_DTYPE_TIME_OF_DAY                  0x000c
#define EPL_OD_DTYPE_TIME_DIFFERENCE              0x000d
#define EPL_OD_DTYPE_DOMAIN                       0x000f
#define EPL_OD_DTYPE_INTEGER24                    0x0010
#define EPL_OD_DTYPE_REAL64                       0x0011
#define EPL_OD_DTYPE_INTEGER40                    0x0012
#define EPL_OD_DTYPE_INTEGER48                    0x0013
#define EPL_OD_DTYPE_INTEGER56                    0x0014
#define EPL_OD_DTYPE_INTEGER64                    0x0015
#define EPL_OD_DTYPE_UNSIGNED24                   0x0016
#define EPL_OD_DTYPE_UNSIGNED40                   0x0018
#define EPL_OD_DTYPE_UNSIGNED48                   0x0019
#define EPL_OD_DTYPE_UNSIGNED56                   0x001a
#define EPL_OD_DTYPE_UNSIGNED64                   0x001b
#define EPL_OD_DTYPE_IDENTITY                     0x0023
#define EPL_OD_DTYPE_COMM_PARAM_RECORD_TYPE       0x0420
#define EPL_OD_DTYPE_NMT_PARAMETERSTORAGE_TYPE    0x0429


/***************************************************************************************/
/* EplCn Pck public, constants */

#define EPLCN_PCK_PROCESS_QUEUE_NAME       "QUE_EPLCN_PCK"


/*
 * Summary of POWERLINK EPL SDO service commands and primitives
 */
//  EPL_SDO_PACKET_COMMAND_START                = 0x1100,

/*
 * Summary of POWERLINK EPL NMT service commands and primitives
 */
//  EPL_NMT_PACKET_COMMAND_START                = 0x1300,

#define EPLCN_PCK_STATE_CHG_REQ_TO_INITIALISING_IND                 0x1300
#define EPLCN_PCK_STATE_CHG_REQ_TO_INITIALISING_RES                 0x1301

#define EPLCN_PCK_STATE_CHG_REQ_TO_RESET_APPLICATION_IND            0x1302
#define EPLCN_PCK_STATE_CHG_REQ_TO_RESET_APPLICATION_RES            0x1303

#define EPLCN_PCK_STATE_CHG_REQ_TO_RESET_COMMUNICATION_IND          0x1304
#define EPLCN_PCK_STATE_CHG_REQ_TO_RESET_COMMUNICATION_RES          0x1305

#define EPLCN_PCK_STATE_CHG_REQ_TO_RESET_CONFIGURATION_IND          0x1306
#define EPLCN_PCK_STATE_CHG_REQ_TO_RESET_CONFIGURATION_RES          0x1307

#define EPLCN_PCK_STATE_CHG_REQ_TO_NOT_ACTIVE_IND                   0x1308
#define EPLCN_PCK_STATE_CHG_REQ_TO_NOT_ACTIVE_RES                   0x1309

#define EPLCN_PCK_STATE_CHG_TO_PRE_OPERATIONAL_1_IND                0x130A
#define EPLCN_PCK_STATE_CHG_TO_PRE_OPERATIONAL_1_RES                0x130B

#define EPLCN_PCK_STATE_CHG_TO_PRE_OPERATIONAL_2_IND                0x130C
#define EPLCN_PCK_STATE_CHG_TO_PRE_OPERATIONAL_2_RES                0x130D

#define EPLCN_PCK_STATE_CHG_TO_READY_TO_OPERATE_IND                 0x130E
#define EPLCN_PCK_STATE_CHG_TO_READY_TO_OPERATE_RES                 0x130F

#define EPLCN_PCK_STATE_CHG_TO_OPERATIONAL_IND                      0x1310
#define EPLCN_PCK_STATE_CHG_TO_OPERATIONAL_RES                      0x1311

#define EPLCN_PCK_STATE_CHG_TO_STOPPED_IND                          0x1312
#define EPLCN_PCK_STATE_CHG_TO_STOPPED_RES                          0x1313

#define EPLCN_PCK_STATE_CHG_TO_BASIC_ETHERNET_IND                   0x1314
#define EPLCN_PCK_STATE_CHG_TO_BASIC_ETHERNET_RES                   0x1315

#define EPLCN_PCK_STATE_ENABLE_RDY_TO_OPERATE_IND                   0x1316
#define EPLCN_PCK_STATE_ENABLE_RDY_TO_OPERATE_RES                   0x1317

#define EPLCN_PCK_GO_TO_READY_TO_OPERATE_REQ                        0x1320
#define EPLCN_PCK_GO_TO_READY_TO_OPERATE_CNF                        0x1321

#define EPLCN_PCK_GO_TO_RESET_APPLICATION_REQ                       0x1322
#define EPLCN_PCK_GO_TO_RESET_APPLICATION_CNF                       0x1323

#define EPLCN_PCK_GO_TO_RESET_COMMUNICATION_REQ                     0x1324
#define EPLCN_PCK_GO_TO_RESET_COMMUNICATION_CNF                     0x1325

#define EPLCN_PCK_GO_TO_RESET_CONFIGURATION_REQ                     0x1326
#define EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CNF                     0x1327

#define EPLCN_PCK_GO_TO_NOT_ACTIVE_REQ                              0x1328
#define EPLCN_PCK_GO_TO_NOT_ACTIVE_CNF                              0x1329

#define EPLCN_PCK_SEND_EMERGENCY_REQ                                0x1330
#define EPLCN_PCK_SEND_EMERGENCY_CNF                                0x1331

#define EPLCN_PCK_REGISTER_REQ                                      0x1340
#define EPLCN_PCK_REGISTER_CNF                                      0x1341

#define EPLCN_PCK_UNREGISTER_REQ                                    0x1342
#define EPLCN_PCK_UNREGISTER_CNF                                    0x1343

#define EPLCN_PCK_ENTER_ERROR_CONDITION_REQ                         0x1344
#define EPLCN_PCK_ENTER_ERROR_CONDITION_CNF                         0x1345

#define EPLCN_PCK_WRITE_ERROR_ENTRY_REQ                             0x1346
#define EPLCN_PCK_WRITE_ERROR_ENTRY_CNF                             0x1347

#define EPLCN_PCK_SET_IO_SIZES_REQ                                  0x1348
#define EPLCN_PCK_SET_IO_SIZES_CNF                                  0x1349

#define EPLCN_PCK_NEW_ERROR_ENTRY_IND                               0x134A
#define EPLCN_PCK_NEW_ERROR_ENTRY_RES                               0x134B

#define EPLCN_PCK_WRITE_STATUS_ENTRY_REQ                            0x134C
#define EPLCN_PCK_WRITE_STATUS_ENTRY_CNF                            0x134D

#define EPLCN_PCK_NEW_STATUS_ENTRY_IND                              0x134E
#define EPLCN_PCK_NEW_STATUS_ENTRY_RES                              0x134F

#define EPLCN_PCK_WRITE_STATIC_BIT_FIELD_REQ                        0x1350
#define EPLCN_PCK_WRITE_STATIC_BIT_FIELD_CNF                        0x1351

#define EPLCN_PCK_CONFIGURE_NUMBER_OF_STATUS_ENTRIES_REQ            0x1352
#define EPLCN_PCK_CONFIGURE_NUMBER_OF_STATUS_ENTRIES_CNF            0x1353

#define EPLCN_PCK_RESET_NODE_REQ                                    0x1360
#define EPLCN_PCK_RESET_NODE_CNF                                    0x1361

#define EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CHG_NODE_ID_REQ         0x1362
#define EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CHG_NODE_ID_CNF         0x1363


/* Object dictionary */
#define EPLCN_PCK_OD_CREATE_OBJECT_REQ                              0x1380
#define EPLCN_PCK_OD_CREATE_OBJECT_CNF                              0x1381
#define EPLCN_PCK_OD_CREATE_SUBOBJECT_REQ                           0x1382
#define EPLCN_PCK_OD_CREATE_SUBOBJECT_CNF                           0x1383
#define EPLCN_PCK_OD_DELETE_OBJECT_REQ                              0x1384
#define EPLCN_PCK_OD_DELETE_OBJECT_CNF                              0x1385

/* Object dicitonary packet notify */
#define EPLCN_PCK_OD_NOTIFY_REGISTER_REQ                            0x1386
#define EPLCN_PCK_OD_NOTIFY_REGISTER_CNF                            0x1387
#define EPLCN_PCK_OD_NOTIFY_UNREGISTER_REQ                          0x1388
#define EPLCN_PCK_OD_NOTIFY_UNREGISTER_CNF                          0x1389
#define EPLCN_PCK_OD_NOTIFY_READ_IND                                0x138A
#define EPLCN_PCK_OD_NOTIFY_READ_RES                                0x138B
#define EPLCN_PCK_OD_NOTIFY_WRITE_IND                               0x138C
#define EPLCN_PCK_OD_NOTIFY_WRITE_RES                               0x138D

#define EPLCN_PCK_OD_CREATE_DATATYPE_REQ                            0x1390
#define EPLCN_PCK_OD_CREATE_DATATYPE_CNF                            0x1391
#define EPLCN_PCK_OD_DELETE_DATATYPE_REQ                            0x1392
#define EPLCN_PCK_OD_DELETE_DATATYPE_CNF                            0x1393

#define EPLCN_PCK_OD_UNDEFINED_NOTIFY_REGISTER_REQ                  0x13A0
#define EPLCN_PCK_OD_UNDEFINED_NOTIFY_REGISTER_CNF                  0x13A1
#define EPLCN_PCK_OD_UNDEFINED_NOTIFY_UNREGISTER_REQ                0x13A2
#define EPLCN_PCK_OD_UNDEFINED_NOTIFY_UNREGISTER_CNF                0x13A3
#define EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_IND                     0x13A8
#define EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_RES                     0x13A9
#define EPLCN_PCK_OD_UNDEFINED_READ_DATA_IND                        0x13AA
#define EPLCN_PCK_OD_UNDEFINED_READ_DATA_RES                        0x13AB
#define EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_IND                       0x13AC
#define EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_RES                       0x13AD

#define EPLCN_PCK_OD_WRITE_OBJECT_REQ                               0x13B0
#define EPLCN_PCK_OD_WRITE_OBJECT_CNF                               0x13B1
#define EPLCN_PCK_OD_READ_OBJECT_REQ                                0x13B2
#define EPLCN_PCK_OD_READ_OBJECT_CNF                                0x13B3

#define EPLCN_DPM_WARMSTART_REQ                                     0x13C0
#define EPLCN_DPM_WARMSTART_CNF                                     0x13C1

#define EPLCN_DPM_SET_CONFIG_REQ                                    0x13C2
#define EPLCN_DPM_SET_CONFIG_CNF                                    0x13C3
#define EPLCN_DPM_SET_CONFIGURATION_REQ                             0x13C2
#define EPLCN_DPM_SET_CONFIGURATION_CNF                             0x13C3

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(EPLCNPCK_PUBLIC)
#endif

/******************************************************************************
 * Request Packet:    EPLCN_PCK_RESET_NODE_REQ_T
 */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_RESET_NODE_REQ_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_RESET_NODE_CNF_T;

/******************************************************************************
 * Request Packet:    EPLCN_PCK_ENTER_ERROR_CONDITION_REQ_T
 */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_ENTER_ERROR_CONDITION_REQ_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_ENTER_ERROR_CONDITION_CNF_T;

/******************************************************************************
 * Request Packet:    EPLCN_PCK_REGISTER_REQ_T
 */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_REGISTER_REQ_T;

typedef __TLR_PACKED_PRE struct EPLCN_PCK_REGISTER_CNF_DATA_Ttag
{
  TLR_HANDLE        hEplCnInterface;      /* only usable if application runs on the same system */
  TLR_HANDLE        hEplCnStack;          /* only usable if application runs on the same system */
} __TLR_PACKED_POST EPLCN_PCK_REGISTER_CNF_DATA_T;

typedef struct EPLCN_PCK_REGISTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  EPLCN_PCK_REGISTER_CNF_DATA_T   tData;
} EPLCN_PCK_REGISTER_CNF_T;

/******************************************************************************
 * Request Packet:    EPLCN_PCK_UNREGISTER_REQ_T
 */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_UNREGISTER_REQ_T;

typedef TLR_EMPTY_PACKET_T EPLCN_PCK_UNREGISTER_CNF_T;

/******************************************************************************
 * Packet for all state change indications
 */

typedef __TLR_PACKED_PRE struct EPLCN_PCK_STATE_IND_DATA_Ttag
{
  TLR_UINT16        usErrorProfile;
  TLR_UINT16        usErrorCode;
  TLR_BOOLEAN32     fErrorLedIsOn;
} __TLR_PACKED_POST EPLCN_PCK_STATE_IND_DATA_T;

typedef struct EPLCN_PCK_STATE_IND_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
  EPLCN_PCK_STATE_IND_DATA_T  tData;
} EPLCN_PCK_STATE_IND_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_REQ_TO_INITIALISING_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_REQ_TO_INITIALISING_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_REQ_TO_INITIALISING_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_REQ_TO_RESET_APPLICATION_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_REQ_TO_RESET_APPLICATION_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_REQ_TO_RESET_APPLICATION_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_ENABLE_RDY_TO_OPERATE_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_ENABLE_RDY_TO_OPERATE_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_ENABLE_RDY_TO_OPERATE_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_REQ_TO_RESET_COMMUNICATION_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_REQ_TO_RESET_COMMUNICATION_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_REQ_TO_RESET_COMMUNICATION_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_REQ_TO_RESET_CONFIGURATION_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_REQ_TO_RESET_CONFIGURATION_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_REQ_TO_RESET_CONFIGURATION_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_REQ_TO_NOT_ACTIVE_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_REQ_TO_NOT_ACTIVE_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_REQ_TO_NOT_ACTIVE_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_TO_PRE_OPERATIONAL_1_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_TO_PRE_OPERATIONAL_1_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_TO_PRE_OPERATIONAL_1_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_TO_PRE_OPERATIONAL_2_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_TO_PRE_OPERATIONAL_2_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_TO_PRE_OPERATIONAL_2_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_TO_READY_TO_OPERATE_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_TO_READY_TO_OPERATE_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_TO_READY_TO_OPERATE_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_TO_OPERATIONAL_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_TO_OPERATIONAL_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_TO_OPERATIONAL_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_TO_STOPPED_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_TO_STOPPED_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_TO_STOPPED_RES_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_STATE_CHG_TO_BASIC_ETHERNET_IND_T
 */
typedef EPLCN_PCK_STATE_IND_T EPLCN_PCK_STATE_CHG_TO_BASIC_ETHERNET_IND_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_STATE_CHG_TO_BASIC_ETHERNET_RES_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_GO_TO_READY_TO_OPERATE_REQ_T
 */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_READY_TO_OPERATE_REQ_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_READY_TO_OPERATE_CNF_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_GO_TO_RESET_APPLICATION_REQ_T
 */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_RESET_APPLICATION_REQ_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_RESET_APPLICATION_CNF_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_GO_TO_RESET_COMMUNICATION_REQ_T
 */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_RESET_COMMUNICATION_REQ_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_RESET_COMMUNICATION_CNF_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_GO_TO_RESET_CONFIGURATION_REQ_T
 */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_RESET_CONFIGURATION_REQ_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CNF_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CHG_NODE_ID REQ_T
 */

/* request packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CHG_NODE_ID_REQ_DATA_Ttag
{
  TLR_UINT8       bNodeId;
} __TLR_PACKED_POST EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CHG_NODE_ID_REQ_DATA_T;

typedef struct EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CHG_NODE_ID_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                         tHead;
  EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CHG_NODE_ID_REQ_DATA_T  tData;
} EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CHG_NODE_ID_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_RESET_CONFIGURATION_CHG_NODE_ID_CNF_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_GO_TO_NOT_ACTIVE_REQ_T
 */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_NOT_ACTIVE_REQ_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_GO_TO_NOT_ACTIVE_CNF_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_SEND_EMERGENCY_REQ_T
 *        CANopen style emergencies
 */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_SEND_EMERGENCY_REQ_DATA_Ttag
{
  TLR_UINT16          usErrorCode;
  TLR_UINT8           bErrorRegister;
  TLR_UINT8           abManufSpecific[5];
  TLR_BOOLEAN32       fEnterErrorCondition;
} __TLR_PACKED_POST EPLCN_PCK_SEND_EMERGENCY_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct EPLCN_PCK_SEND_EMERGENCY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  EPLCN_PCK_SEND_EMERGENCY_REQ_DATA_T   tData;
} __TLR_PACKED_POST EPLCN_PCK_SEND_EMERGENCY_REQ_T;

typedef TLR_EMPTY_PACKET_T EPLCN_PCK_SEND_EMERGENCY_CNF_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_WRITE_ERROR_ENTRY_REQ_T
 */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_WRITE_ERROR_ENTRY_REQ_DATA_Ttag
{
  /* EPL entry type (Octets 0 and 1 of Error Entry) */
  TLR_UINT16                      usEntryType;
  /* EPL error code (Octets 2 and 3 of Error Entry) */
  TLR_UINT16                      usErrorCode;
  /* Additional information (Octets 11 to 19 of Error Entry) */
  TLR_UINT32                      aulAddInformation[2];
  /* Enter Error Condition */
  TLR_BOOLEAN32                   fEnterErrorCondition;
} __TLR_PACKED_POST EPLCN_PCK_WRITE_ERROR_ENTRY_REQ_DATA_T;

typedef struct EPLCN_PCK_WRITE_ERROR_ENTRY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  EPLCN_PCK_WRITE_ERROR_ENTRY_REQ_DATA_T  tData;
} EPLCN_PCK_WRITE_ERROR_ENTRY_REQ_T;

typedef TLR_EMPTY_PACKET_T EPLCN_PCK_WRITE_ERROR_ENTRY_CNF_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_NEW_ERROR_ENTRY_IND_T
 */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_NEW_ERROR_ENTRY_IND_DATA_Ttag
{
  /* EPL entry type (Octets 0 and 1 of Error Entry) */
  TLR_UINT16                      usEntryType;
  /* EPL error code (Octets 2 and 3 of Error Entry) */
  TLR_UINT16                      usErrorCode;
  /* Additional information (Octets 11 to 19 of Error Entry) */
  TLR_UINT32                      aulAddInformation[2];
} __TLR_PACKED_POST EPLCN_PCK_NEW_ERROR_ENTRY_IND_DATA_T;

typedef struct EPLCN_PCK_NEW_ERROR_ENTRY_IND_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  EPLCN_PCK_NEW_ERROR_ENTRY_IND_DATA_T  tData;
} EPLCN_PCK_NEW_ERROR_ENTRY_IND_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_WRITE_STATUS_ENTRY_REQ_T
 */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_WRITE_STATUS_ENTRY_REQ_DATA_Ttag
{
  /* Status Entry Number */
  TLR_UINT16                      usStatusEntryNumber;
  /* EPL entry type (Octets 0 and 1 of Error Entry) */
  TLR_UINT16                      usEntryType;
  /* EPL error code (Octets 2 and 3 of Error Entry) */
  TLR_UINT16                      usErrorCode;
  /* Additional information (Octets 11 to 19 of Error Entry) */
  TLR_UINT32                      aulAddInformation[2];
  /* Enter Error Condition */
  TLR_BOOLEAN32                   fEnterErrorCondition;
} __TLR_PACKED_POST EPLCN_PCK_WRITE_STATUS_ENTRY_REQ_DATA_T;

typedef struct EPLCN_PCK_WRITE_STATUS_ENTRY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  EPLCN_PCK_WRITE_STATUS_ENTRY_REQ_DATA_T tData;
} EPLCN_PCK_WRITE_STATUS_ENTRY_REQ_T;

typedef TLR_EMPTY_PACKET_T EPLCN_PCK_WRITE_STATUS_ENTRY_CNF_T;

/******************************************************************************
 * Indication Packet:   EPLCN_PCK_NEW_STATUS_ENTRY_IND_T
 */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_NEW_STATUS_ENTRY_IND_DATA_Ttag
{
  /* Status Entry Number */
  TLR_UINT16                      usStatusEntryNumber;
  /* EPL entry type (Octets 0 and 1 of Error Entry) */
  TLR_UINT16                      usEntryType;
  /* EPL error code (Octets 2 and 3 of Error Entry) */
  TLR_UINT16                      usErrorCode;
  /* Additional information (Octets 11 to 19 of Error Entry) */
  TLR_UINT32                      aulAddInformation[2];
} __TLR_PACKED_POST EPLCN_PCK_NEW_STATUS_ENTRY_IND_DATA_T;

typedef struct EPLCN_PCK_NEW_STATUS_ENTRY_IND_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  EPLCN_PCK_NEW_STATUS_ENTRY_IND_DATA_T tData;
} EPLCN_PCK_NEW_STATUS_ENTRY_IND_T;

/******************************************************************************
 * Request Packet:   EPLCN_PCK_WRITE_STATIC_BIT_FIELD_REQ_T
 */

/* request packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_WRITE_STATIC_BIT_FIELD_REQ_DATA_ENTRY_Ttag
{
  /* Bit number */
  TLR_UINT8                       bBitNumber;
  /* Bit value */
  TLR_BOOLEAN8                    fBitValue;
} __TLR_PACKED_POST EPLCN_PCK_WRITE_STATIC_BIT_FIELD_REQ_DATA_ENTRY_T;

typedef __TLR_PACKED_PRE struct EPLCN_PCK_WRITE_STATIC_BIT_FIELD_REQ_DATA_Ttag
{
  EPLCN_PCK_WRITE_STATIC_BIT_FIELD_REQ_DATA_ENTRY_T atEntry[1];
} __TLR_PACKED_POST EPLCN_PCK_WRITE_STATIC_BIT_FIELD_REQ_DATA_T;

typedef struct EPLCN_PCK_WRITE_STATIC_BIT_FIELD_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  EPLCN_PCK_WRITE_STATIC_BIT_FIELD_REQ_DATA_T tData;
} EPLCN_PCK_WRITE_STATIC_BIT_FIELD_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_WRITE_STATIC_BIT_FIELD_CNF_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_SET_IO_SIZES_REQ_T
 */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_SET_IO_SIZES_REQ_DATA_T
{
  /** Process Data Output Size */
  TLR_UINT16      usProcessDataOutputSize;
  /** Process Data Input Size */
  TLR_UINT16      usProcessDataInputSize;
} __TLR_PACKED_POST EPLCN_PCK_SET_IO_SIZES_REQ_DATA_T;

typedef struct EPLCN_PCK_SET_IO_SIZES_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  EPLCN_PCK_SET_IO_SIZES_REQ_DATA_T tData;
} EPLCN_PCK_SET_IO_SIZES_REQ_T;

typedef TLR_EMPTY_PACKET_T EPLCN_PCK_SET_IO_SIZES_CNF_T;

/******************************************************************************
 * Request Packet:      EPLCN_PCK_CONFIGURE_NUMBER_OF_STATUS_ENTRIES_REQ
 */

 /* request packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_CONFIGURE_NUMBER_OF_STATUS_ENTRIES_REQ_DATA_Ttag
{
  /* number of status entries to configure */
  TLR_UINT8       bNumberOfStatusEntries;
} __TLR_PACKED_POST EPLCN_PCK_CONFIGURE_NUMBER_OF_STATUS_ENTRIES_REQ_DATA_T;

typedef struct EPLCN_PCK_CONFIGURE_NUMBER_OF_STATUS_ENTRIES_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                         tHead;
  EPLCN_PCK_CONFIGURE_NUMBER_OF_STATUS_ENTRIES_REQ_DATA_T     tData;
} EPLCN_PCK_CONFIGURE_NUMBER_OF_STATUS_ENTRIES_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_CONFIGURE_NUMBER_OF_STATUS_ENTRIES_CNF_T;

/******************************************************************************
 * Request Packet:      EPLCN_DPM_WARMSTART_REQ_T
 */
typedef __TLR_PACKED_PRE struct EPLCN_DPM_WARMSTART_REQ_DATA_Ttag
{
  /** reserved for IO status */
  TLR_UINT32      ulSystemFlags;
  /** watchdog time in millisecs */
  TLR_UINT32      ulWatchdogTime;
  /** Vendor Id */
  TLR_UINT32      ulVendorId;
  /** Produt code */
  TLR_UINT32      ulProductCode;
  /** Revision number */
  TLR_UINT32      ulRevisionNumber;
  /** Serial number (0 will use default serial number from Sec Mem if available) */
  TLR_UINT32      ulSerialNumber;
  /** Stack Configuration Flags */
  TLR_UINT32      ulStackConfigurationFlags;
  /** Threshold disable flags (see MSK_EPLCN_DPM_WARMSTART_THRESHOLD_DISABLE_* definitions) */
  TLR_UINT32      ulThresholdDisableFlags;
  /** LossSoC Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdLossSoC;
  /** LossPReq Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdLossPReq;
  /** LossSoA Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdLossSoA;
  /** SoCJitter Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdSoCJitter;
  /** Collision Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdCollision;
  /** CrcError Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdCrcError;
  /** Cycle Length configuration (ns) (ignored if set to 0) */
  TLR_UINT32      ulCycleLength;
  /** SoC Jitter range configuration (ns) (ignored if set to 0) */
  TLR_UINT32      ulSoCJitterRange;
  /** Process Data Output Size (range 0 to 1490) */
  TLR_UINT16      usProcessDataOutputSize;
  /** Process Data Input Size (range 0 to 1490) */
  TLR_UINT16      usProcessDataInputSize;
  /** EPL node name */
  TLR_UINT8       abNodeName[32];
  /** IP Gateway (ignored if set to 0) */
  TLR_UINT32      ulGatewayAddress;
  /** EPL node id (range 1 to 239) */
  TLR_UINT8       bNodeId;
  /** SoC Trigger configuration (see MSK_EPLCN_DPM_WARMSTART_SOC_TRIGGER_CONFIG_* definitions) */
  TLR_UINT8       bSoCTriggerConfig;
  /** SoC Trigger Delay configuration (ns) */
  TLR_UINT32      ulSoCTriggerDelay;
  /** SoC Trigger Length configuration (ns) */
  TLR_UINT32      ulSoCTriggerLength;
  /** PReq Mapping Version */
  TLR_UINT8       bPReqMappingVersion;
  /** PRes Mapping Version */
  TLR_UINT8       bPResMappingVersion;
  /** configured status entries */
  TLR_UINT8       bNumberOfStatusEntries;
  /* same structure as EPLCN_DPM_WARMSTART_OLD_REQ_DATA_T until here */

  /** PReq Bus-Synchronous error threshold (only valid if MSK_EPLCN_DPM_WARMSTART_STACK_CFG_CONFIGURE_BUS_SYNCHRONOUS_MODE is set) */
  TLR_UINT32      ulPReqErrorThreshold;

  /** PRes Bus-Synchronous error threshold (only valid if MSK_EPLCN_DPM_WARMSTART_STACK_CFG_CONFIGURE_BUS_SYNCHRONOUS_MODE is set) */
  TLR_UINT32      ulPResErrorThreshold;

  /** Sync Flag error threshold (only valid if MSK_EPLCN_DPM_WARMSTART_STACK_CFG_CONFIGURE_BUS_SYNCHRONOUS_MODE is set) */
  TLR_UINT32      ulSyncFlagErrorThreshold;
  /* same structure as EPLCN_DPM_WARMSTART_R2_REQ_DATA_T until here */
  /** value for obj 1000 holding the profile of a device */
  TLR_UINT32      ulDeviceType;
} __TLR_PACKED_POST EPLCN_DPM_WARMSTART_REQ_DATA_T;

typedef struct EPLCN_DPM_WARMSTART_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  EPLCN_DPM_WARMSTART_REQ_DATA_T  tData;
} EPLCN_DPM_WARMSTART_REQ_T;


typedef __TLR_PACKED_PRE struct EPLCN_DPM_WARMSTART_R2_REQ_DATA_Ttag
{
  /** reserved for IO status */
  TLR_UINT32      ulSystemFlags;
  /** watchdog time in millisecs */
  TLR_UINT32      ulWatchdogTime;
  /** Vendor Id */
  TLR_UINT32      ulVendorId;
  /** Produt code */
  TLR_UINT32      ulProductCode;
  /** Revision number */
  TLR_UINT32      ulRevisionNumber;
  /** Serial number (0 will use default serial number from Sec Mem if available) */
  TLR_UINT32      ulSerialNumber;
  /** Stack Configuration Flags */
  TLR_UINT32      ulStackConfigurationFlags;
  /** Threshold disable flags (see MSK_EPLCN_DPM_WARMSTART_THRESHOLD_DISABLE_* definitions) */
  TLR_UINT32      ulThresholdDisableFlags;
  /** LossSoC Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdLossSoC;
  /** LossPReq Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdLossPReq;
  /** LossSoA Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdLossSoA;
  /** SoCJitter Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdSoCJitter;
  /** Collision Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdCollision;
  /** CrcError Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdCrcError;
  /** Cycle Length configuration (ns) (ignored if set to 0) */
  TLR_UINT32      ulCycleLength;
  /** SoC Jitter range configuration (ns) (ignored if set to 0) */
  TLR_UINT32      ulSoCJitterRange;
  /** Process Data Output Size (range 0 to 1490) */
  TLR_UINT16      usProcessDataOutputSize;
  /** Process Data Input Size (range 0 to 1490) */
  TLR_UINT16      usProcessDataInputSize;
  /** EPL node name */
  TLR_UINT8       abNodeName[32];
  /** IP Gateway (ignored if set to 0) */
  TLR_UINT32      ulGatewayAddress;
  /** EPL node id (range 1 to 239) */
  TLR_UINT8       bNodeId;
  /** SoC Trigger configuration (see MSK_EPLCN_DPM_WARMSTART_SOC_TRIGGER_CONFIG_* definitions) */
  TLR_UINT8       bSoCTriggerConfig;
  /** SoC Trigger Delay configuration (ns) */
  TLR_UINT32      ulSoCTriggerDelay;
  /** SoC Trigger Length configuration (ns) */
  TLR_UINT32      ulSoCTriggerLength;
  /** PReq Mapping Version */
  TLR_UINT8       bPReqMappingVersion;
  /** PRes Mapping Version */
  TLR_UINT8       bPResMappingVersion;
  /** configured status entries */
  TLR_UINT8       bNumberOfStatusEntries;
  /* same structure as EPLCN_DPM_WARMSTART_OLD_REQ_DATA_T until here */

  /** PReq Bus-Synchronous error threshold (only valid if MSK_EPLCN_DPM_WARMSTART_STACK_CFG_CONFIGURE_BUS_SYNCHRONOUS_MODE is set) */
  TLR_UINT32      ulPReqErrorThreshold;

  /** PRes Bus-Synchronous error threshold (only valid if MSK_EPLCN_DPM_WARMSTART_STACK_CFG_CONFIGURE_BUS_SYNCHRONOUS_MODE is set) */
  TLR_UINT32      ulPResErrorThreshold;

  /** Sync Flag error threshold (only valid if MSK_EPLCN_DPM_WARMSTART_STACK_CFG_CONFIGURE_BUS_SYNCHRONOUS_MODE is set) */
  TLR_UINT32      ulSyncFlagErrorThreshold;
} __TLR_PACKED_POST EPLCN_DPM_WARMSTART_R2_REQ_DATA_T;

typedef struct EPLCN_DPM_WARMSTART_R2_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  EPLCN_DPM_WARMSTART_R2_REQ_DATA_T tData;
} EPLCN_DPM_WARMSTART_R2_REQ_T;


typedef __TLR_PACKED_PRE struct EPLCN_DPM_WARMSTART_OLD_REQ_DATA_Ttag
{
  /** reserved for IO status */
  TLR_UINT32      ulSystemFlags;
  /** watchdog time in millisecs */
  TLR_UINT32      ulWatchdogTime;
  /** Vendor Id */
  TLR_UINT32      ulVendorId;
  /** Produt code */
  TLR_UINT32      ulProductCode;
  /** Revision number */
  TLR_UINT32      ulRevisionNumber;
  /** Serial number (0 will use default serial number from Sec Mem if available) */
  TLR_UINT32      ulSerialNumber;
  /** Stack Configuration Flags */
  TLR_UINT32      ulStackConfigurationFlags;
  /** Threshold disable flags (see MSK_EPLCN_DPM_WARMSTART_THRESHOLD_DISABLE_* definitions) */
  TLR_UINT32      ulThresholdDisableFlags;
  /** LossSoC Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdLossSoC;
  /** LossPReq Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdLossPReq;
  /** LossSoA Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdLossSoA;
  /** SoCJitter Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdSoCJitter;
  /** Collision Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdCollision;
  /** CrcError Threshold (ignored if set to 0) */
  TLR_UINT32      ulThresholdCrcError;
  /** Cycle Length configuration (ns) (ignored if set to 0) */
  TLR_UINT32      ulCycleLength;
  /** SoC Jitter range configuration (ns) (ignored if set to 0) */
  TLR_UINT32      ulSoCJitterRange;
  /** Process Data Output Size (range 0 to 1490) */
  TLR_UINT16      usProcessDataOutputSize;
  /** Process Data Input Size (range 0 to 1490) */
  TLR_UINT16      usProcessDataInputSize;
  /** EPL node name */
  TLR_UINT8       abNodeName[32];
  /** IP Gateway (ignored if set to 0) */
  TLR_UINT32      ulGatewayAddress;
  /** EPL node id (range 1 to 239) */
  TLR_UINT8       bNodeId;
  /** SoC Trigger configuration (see MSK_EPLCN_DPM_WARMSTART_SOC_TRIGGER_CONFIG_* definitions) */
  TLR_UINT8       bSoCTriggerConfig;
  /** SoC Trigger Delay configuration (ns) */
  TLR_UINT32      ulSoCTriggerDelay;
  /** SoC Trigger Length configuration (ns) */
  TLR_UINT32      ulSoCTriggerLength;
  /** PReq Mapping Version */
  TLR_UINT8       bPReqMappingVersion;
  /** PRes Mapping Version */
  TLR_UINT8       bPResMappingVersion;
  /** configured status entries */
  TLR_UINT8       bNumberOfStatusEntries;
} __TLR_PACKED_POST EPLCN_DPM_WARMSTART_OLD_REQ_DATA_T;

typedef struct EPLCN_DPM_WARMSTART_OLD_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  EPLCN_DPM_WARMSTART_OLD_REQ_DATA_T  tData;
} EPLCN_DPM_WARMSTART_OLD_REQ_T;


typedef TLR_EMPTY_PACKET_T EPLCN_DPM_WARMSTART_CNF_T;

/* ulSystemFlags */
#define MSK_EPLCN_DPM_WARMSTART_APP_CONTROLLED                                0x00000001
#define MSK_EPLCN_DPM_WARMSTART_SYSTEMFLAGS_ACTIVE                            0x00000002
#define MSK_EPLCN_DPM_WARMSTART_SYSTEMFLAGS_32BIT                             0x00000004
#define MSK_EPLCN_DPM_WARMSTART_ADR_SW_ENABLE                                 0x00000010

/* ulThresholdDisableFlags */
#define MSK_EPLCN_DPM_WARMSTART_THRESHOLD_DISABLE_LOSS_SOC_TH                 0x00000001
#define MSK_EPLCN_DPM_WARMSTART_THRESHOLD_DISABLE_LOSS_PREQ_TH                0x00000002
#define MSK_EPLCN_DPM_WARMSTART_THRESHOLD_DISABLE_LOSS_SOA_TH                 0x00000004
#define MSK_EPLCN_DPM_WARMSTART_THRESHOLD_DISABLE_SOC_JITTER_TH               0x00000008
#define MSK_EPLCN_DPM_WARMSTART_THRESHOLD_DISABLE_COLLISION_TH                0x00000010
#define MSK_EPLCN_DPM_WARMSTART_THRESHOLD_DISABLE_CRC_ERROR_TH                0x00000020

/* bSoCTriggerConfig */
#define MSK_EPLCN_DPM_WARMSTART_SOC_TRIGGER_CONFIG_OUTPUT_ENABLE              0x01
#define MSK_EPLCN_DPM_WARMSTART_SOC_TRIGGER_CONFIG_POLARITY                   0x02

/* ulStackConfigurationFlags */
#define MSK_EPLCN_DPM_WARMSTART_STACK_CFG_DISABLE_HOST_TRIGGERED_INPUT_XCHG   0x00000001
#define MSK_EPLCN_DPM_WARMSTART_STACK_CFG_DISABLE_HOST_TRIGGERED_OUTPUT_XCHG  0x00000002
#define MSK_EPLCN_DPM_WARMSTART_STACK_CFG_CONFIGURE_DEFAULT_OBJECTS           0x00000004
#define MSK_EPLCN_DPM_WARMSTART_STACK_CFG_DELETE_APPLICATION_OBJECTS          0x00000008
#define MSK_EPLCN_DPM_WARMSTART_STACK_CFG_DISABLE_PDO_MAP_VERS_CHECK          0x00000010
#define MSK_EPLCN_DPM_WARMSTART_STACK_CFG_USE_APP_READY_FOR_PRES_RD_FLAG      0x00000020
#define MSK_EPLCN_DPM_WARMSTART_STACK_CFG_CONFIGURE_BUS_SYNCHRONOUS_MODE      0x00000040
#define MSK_EPLCN_DPM_WARMSTART_STACK_CFG_USE_PREQ_RX_FOR_PRES_DATA_EXCHANGE  0x00000080    /* use this for synchronous applications */
#define MSK_EPLCN_DPM_WARMSTART_STACK_CFG_APP_WILL_USE_NODEID_BY_SW           0x00000100    /* if set, application has to implement 1F93.3 */
#define MSK_EPLCN_DPM_WARMSTART_STACK_CFG_APP_WILL_USE_DYNAMIC_PDO_MAPPING    0x00000200    /* application implements dynamic PDO mapping */

/******************************************************************************
 * Request Packet:      EPLCN_DPM_SET_CONFIG_REQ_T
 */
typedef EPLCN_DPM_WARMSTART_REQ_DATA_T EPLCN_DPM_SET_CONFIG_REQ_DATA_T;

typedef struct EPLCN_DPM_SET_CONFIG_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  EPLCN_DPM_SET_CONFIG_REQ_DATA_T tData;
} EPLCN_DPM_SET_CONFIG_REQ_T;

typedef EPLCN_DPM_SET_CONFIG_REQ_T EPLCN_DPM_SET_CONFIGURATION_REQ_T;

/****/
typedef EPLCN_DPM_WARMSTART_R2_REQ_DATA_T EPLCN_DPM_SET_CONFIG_R2_REQ_DATA_T;

typedef struct EPLCN_DPM_SET_CONFIG_R2_REQ_Ttag
{
  TLR_PACKET_HEADER_T                tHead;
  EPLCN_DPM_SET_CONFIG_R2_REQ_DATA_T tData;
} EPLCN_DPM_SET_CONFIG_R2_REQ_T;

typedef EPLCN_DPM_SET_CONFIG_R2_REQ_T EPLCN_DPM_SET_CONFIGURATION_R2_REQ_T;

/****/

typedef struct EPLCN_DPM_SET_CONFIG_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
} EPLCN_DPM_SET_CONFIG_CNF_T;

typedef EPLCN_DPM_SET_CONFIG_CNF_T EPLCN_DPM_SET_CONFIGURATION_CNF_T;

/* ulSystemFlags */
#define MSK_EPLCN_DPM_SET_CONFIG_APP_CONTROLLED                                0x00000001
#define MSK_EPLCN_DPM_SET_CONFIG_SYSTEMFLAGS_ACTIVE                            0x00000002
#define MSK_EPLCN_DPM_SET_CONFIG_SYSTEMFLAGS_32BIT                             0x00000004
#define MSK_EPLCN_DPM_SET_CONFIG_ADR_SW_ENABLE                                 0x00000010

/* ulThresholdDisableFlags */
#define MSK_EPLCN_DPM_SET_CONFIG_THRESHOLD_DISABLE_LOSS_SOC_TH                 0x00000001
#define MSK_EPLCN_DPM_SET_CONFIG_THRESHOLD_DISABLE_LOSS_PREQ_TH                0x00000002
#define MSK_EPLCN_DPM_SET_CONFIG_THRESHOLD_DISABLE_LOSS_SOA_TH                 0x00000004
#define MSK_EPLCN_DPM_SET_CONFIG_THRESHOLD_DISABLE_SOC_JITTER_TH               0x00000008
#define MSK_EPLCN_DPM_SET_CONFIG_THRESHOLD_DISABLE_COLLISION_TH                0x00000010
#define MSK_EPLCN_DPM_SET_CONFIG_THRESHOLD_DISABLE_CRC_ERROR_TH                0x00000020

/* bSoCTriggerConfig */
#define MSK_EPLCN_DPM_SET_CONFIG_SOC_TRIGGER_CONFIG_OUTPUT_ENABLE              0x01
#define MSK_EPLCN_DPM_SET_CONFIG_SOC_TRIGGER_CONFIG_POLARITY                   0x02

/* ulStackConfigurationFlags */
#define MSK_EPLCN_DPM_SET_CONFIG_STACK_CFG_DISABLE_HOST_TRIGGERED_INPUT_XCHG   0x00000001
#define MSK_EPLCN_DPM_SET_CONFIG_STACK_CFG_DISABLE_HOST_TRIGGERED_OUTPUT_XCHG  0x00000002
#define MSK_EPLCN_DPM_SET_CONFIG_STACK_CFG_CONFIGURE_DEFAULT_OBJECTS           0x00000004
#define MSK_EPLCN_DPM_SET_CONFIG_STACK_CFG_DELETE_APPLICATION_OBJECTS          0x00000008
#define MSK_EPLCN_DPM_SET_CONFIG_STACK_CFG_DISABLE_PDO_MAP_VERS_CHECK          0x00000010
#define MSK_EPLCN_DPM_SET_CONFIG_STACK_CFG_USE_APP_READY_FOR_PRES_RD_FLAG      0x00000020
#define MSK_EPLCN_DPM_SET_CONFIG_STACK_CFG_CONFIGURE_BUS_SYNCHRONOUS_MODE      0x00000040
#define MSK_EPLCN_DPM_SET_CONFIG_STACK_CFG_USE_PREQ_RX_FOR_PRES_DATA_EXCHANGE  0x00000080    /* use this for synchronous applications */
#define MSK_EPLCN_DPM_SET_CONFIG_STACK_CFG_APP_WILL_USE_NODEID_BY_SW           0x00000100    /* if set, application has to implement 1F93.3 */
#define MSK_EPLCN_DPM_SET_CONFIG_STACK_CFG_APP_WILL_USE_DYNAMIC_PDO_MAPPING    0x00000200    /* application implements dynamic PDO mapping */

/******************************************************************************
 * Packet EPLCN_PCK_OD_CREATE_OBJECT_REQ/EPLCN_PCK_OD_CREATE_OBJECT_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_CREATE_OBJECT_REQ_DATA_Ttag
{
  TLR_UINT16          usIndex;
  TLR_UINT8           bNumOfSubObjs;
  TLR_UINT8           bMaxNumOfSubObjs;
  TLR_UINT16          usObjAccess;
  TLR_UINT8           bObjectCode;
  TLR_UINT16          usDatatype;
} __TLR_PACKED_POST EPLCN_PCK_OD_CREATE_OBJECT_REQ_DATA_T;

typedef struct EPLCN_PCK_OD_CREATE_OBJECT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  EPLCN_PCK_OD_CREATE_OBJECT_REQ_DATA_T   tData;
} EPLCN_PCK_OD_CREATE_OBJECT_REQ_T;

#define EPLCN_PCK_OD_CREATE_OBJECT_OBJ_ACCESS_RXPDOMAP (0x0001)
#define EPLCN_PCK_OD_CREATE_OBJECT_OBJ_ACCESS_TXPDOMAP (0x0002)
#define EPLCN_PCK_OD_CREATE_OBJECT_OBJ_ACCESS_CONFIG (0x0004)
#define EPLCN_PCK_OD_CREATE_OBJECT_OBJ_ACCESS_INDEXED (0x0008)
#define EPLCN_PCK_OD_CREATE_OBJECT_OBJ_ACCESS_PDOMAP (0x0003)
#define EPLCN_PCK_OD_CREATE_OBJECT_OBJ_ACCESS_BACKUP (0x0010)

/* confirmation packet */

typedef TLR_PACKET_HEADER_T EPLCN_PCK_OD_CREATE_OBJECT_CNF_T;


/******************************************************************************
 * Packet EPLCN_PCK_OD_CREATE_SUBOBJECT_REQ/EPLCN_PCK_OD_CREATE_SUBOBJECT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_CREATE_SUBOBJECT_REQ_DATA_Ttag
{
  TLR_UINT32          ulMode;
  TLR_UINT16          usIndex;
  TLR_UINT8           bSubIdx;
  TLR_UINT16          usDirection;
  TLR_UINT16          usSubObjAccess;
  TLR_UINT16          usDatatype;
  TLR_UINT16          usFieldLen;         /* used if data type allows variable size */
  TLR_UINT32          ulRelativeAddress;  /* used if EPLCN_PCK_OD_SUBOBJECT_MODE_IN_DPM_BLOCK is set */
} __TLR_PACKED_POST EPLCN_PCK_OD_CREATE_SUBOBJECT_REQ_DATA_T;

/* values for ulMode */
/* Object data is held in a self-contained memory area */
#define EPLCN_PCK_OD_SUBOBJECT_MODE_STORAGE           0
/* Object data is reflected directly from DPM block (always Read Only, only supported on DPM firmwares) */
#define EPLCN_PCK_OD_SUBOBJECT_MODE_IN_DPM_BLOCK      1


#define EPLCN_PCK_OD_SUBOBJECT_DIRECTION_NOT_DEF  0x0
#define EPLCN_PCK_OD_SUBOBJECT_DIRECTION_INPUT    0x1    //input of the device (Slave -> Master)
#define EPLCN_PCK_OD_SUBOBJECT_DIRECTION_OUTPUT   0x2    //output of the device (Master -> Slave)
#define EPLCN_PCK_OD_SUBOBJECT_DIRECTION_ALL      0x3

typedef struct EPLCN_PCK_OD_CREATE_SUBOBJECT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  EPLCN_PCK_OD_CREATE_SUBOBJECT_REQ_DATA_T  tData;
} EPLCN_PCK_OD_CREATE_SUBOBJECT_REQ_T;

/* confirmation packet */

typedef TLR_PACKET_HEADER_T EPLCN_PCK_OD_CREATE_SUBOBJECT_CNF_T;


/******************************************************************************
 * Packet EPLCN_PCK_OD_DELETE_OBJECT_REQ/EPLCN_PCK_OD_DELETE_OBJECT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_DELETE_OBJECT_REQ_DATA_Ttag
{
  TLR_BOOLEAN32       fDeleteWholeObject;
  TLR_UINT16          usIndex;
  TLR_UINT8           bSubIdx;
} __TLR_PACKED_POST EPLCN_PCK_OD_DELETE_OBJECT_REQ_DATA_T;

typedef struct EPLCN_PCK_OD_DELETE_OBJECT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  EPLCN_PCK_OD_DELETE_OBJECT_REQ_DATA_T tData;
} EPLCN_PCK_OD_DELETE_OBJECT_REQ_T;

/* confirmation packet */

typedef TLR_PACKET_HEADER_T EPLCN_PCK_OD_DELETE_OBJECT_CNF_T;


/******************************************************************************
 * Packet EPLCN_PCK_OD_NOTIFY_REGISTER_REQ/EPLCN_PCK_OD_NOTIFY_REGISTER_CNF
 * Packet EPLCN_PCK_OD_NOTIFY_UNREGISTER_REQ/EPLCN_PCK_OD_NOTIFY_UNREGISTER_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_NOTIFY_REQ_DATA_Ttag
{
  TLR_UINT16                  usIndex;
  TLR_BOOLEAN32               fReadNotify;
  TLR_BOOLEAN32               fWriteNotify;
} __TLR_PACKED_POST EPLCN_PCK_OD_NOTIFY_REQ_DATA_T;

struct EPLCN_PCK_OD_NOTIFY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  EPLCN_PCK_OD_NOTIFY_REQ_DATA_T        tData;
};

typedef struct EPLCN_PCK_OD_NOTIFY_REQ_Ttag EPLCN_PCK_OD_NOTIFY_REGISTER_REQ_T;
typedef struct EPLCN_PCK_OD_NOTIFY_REQ_Ttag EPLCN_PCK_OD_NOTIFY_UNREGISTER_REQ_T;

/* confirmation packet */

typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_NOTIFY_REGISTER_CNF_T;
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_NOTIFY_UNREGISTER_CNF_T;


/******************************************************************************
 * Packet EPLCN_PCK_OD_NOTIFY_READ_IND
 */

/* indication packet */

typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_NOTIFY_READ_IND_DATA_Ttag
{
  TLR_UINT16          usObjIndex;
  TLR_UINT8           bSubIdx;
  TLR_UINT32          ulExpectedDataSize;
} __TLR_PACKED_POST EPLCN_PCK_OD_NOTIFY_READ_IND_DATA_T;

#define EPLCN_PCK_OD_NOTIFY_MAX_DATA_BUFFER_SIZE 2048

typedef struct EPLCN_PCK_OD_NOTIFY_READ_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  EPLCN_PCK_OD_NOTIFY_READ_IND_DATA_T     tData;
} EPLCN_PCK_OD_NOTIFY_READ_IND_T;

/* response packet */

typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_NOTIFY_READ_RES_DATA_Ttag
{
  TLR_UINT16          usObjIndex;
  TLR_UINT8           bSubIdx;
} __TLR_PACKED_POST EPLCN_PCK_OD_NOTIFY_READ_RES_DATA_T;

typedef struct EPLCN_PCK_OD_NOTIFY_READ_RES_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  EPLCN_PCK_OD_NOTIFY_READ_RES_DATA_T     tData;
} EPLCN_PCK_OD_NOTIFY_READ_RES_T;


/* combined packet */
typedef union EPLCN_PCK_OD_NOTIFY_READ_PCK_Ttag
{
  EPLCN_PCK_OD_NOTIFY_READ_IND_T    tOdReadInd;
  EPLCN_PCK_OD_NOTIFY_READ_RES_T    tOdReadRes;
} EPLCN_PCK_OD_NOTIFY_READ_PCK_T;

/******************************************************************************
 * Packet EPLCN_PCK_OD_NOTIFY_WRITE_IND
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_NOTIFY_WRITE_IND_DATA_Ttag
{
  TLR_UINT16          usObjIndex;
  TLR_UINT8           bSubIdx;
} __TLR_PACKED_POST EPLCN_PCK_OD_NOTIFY_WRITE_IND_DATA_T;

typedef struct EPLCN_PCK_OD_NOTIFY_WRITE_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  EPLCN_PCK_OD_NOTIFY_WRITE_IND_DATA_T    tData;
} EPLCN_PCK_OD_NOTIFY_WRITE_IND_T;

/* response packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_NOTIFY_WRITE_RES_T;

/* combined packet */
typedef union EPLCN_PCK_OD_NOTIFY_WRITE_PCK_Ttag
{
  EPLCN_PCK_OD_NOTIFY_WRITE_IND_T   tOdWriteInd;
  EPLCN_PCK_OD_NOTIFY_WRITE_RES_T   tOdWriteRes;
} EPLCN_PCK_OD_NOTIFY_WRITE_PCK_T;

/******************************************************************************
 * Packet EPLCN_PCK_OD_CREATE_DATATYPE_REQ/EPLCN_PCK_OD_CREATE_DATATYPE_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_CREATE_DATATYPE_REQ_DATA_Ttag
{
  TLR_UINT16          usDatatype;
  TLR_UINT32          ulBitLength;
  TLR_BOOLEAN32       fVariableLength;
} __TLR_PACKED_POST EPLCN_PCK_OD_CREATE_DATATYPE_REQ_DATA_T;

typedef struct EPLCN_PCK_OD_CREATE_DATATYPE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  EPLCN_PCK_OD_CREATE_DATATYPE_REQ_DATA_T   tData;
} EPLCN_PCK_OD_CREATE_DATATYPE_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_CREATE_DATATYPE_CNF_T;


/******************************************************************************
 * Packet EPLCN_PCK_OD_DELETE_DATATYPE_REQ/EPLCN_PCK_OD_DELETE_DATATYPE_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_DELETE_DATATYPE_REQ_DATA_Ttag
{
  TLR_UINT16          usDatatype;
} __TLR_PACKED_POST EPLCN_PCK_OD_DELETE_DATATYPE_REQ_DATA_T;

typedef struct EPLCN_PCK_OD_DELETE_DATATYPE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  EPLCN_PCK_OD_DELETE_DATATYPE_REQ_DATA_T   tData;
} EPLCN_PCK_OD_DELETE_DATATYPE_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_DELETE_DATATYPE_CNF_T;

/******************************************************************************
 * Packet EPLCN_PCK_OD_UNDEFINED_NOTIFY_REGISTER_REQ/EPLCN_PCK_OD_UNDEFINED_NOTIFY_REGISTER_CNF
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_UNDEFINED_NOTIFY_REGISTER_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_UNDEFINED_NOTIFY_REGISTER_CNF_T;


/******************************************************************************
 * Packet EPLCN_PCK_OD_UNDEFINED_NOTIFY_UNREGISTER_REQ/EPLCN_PCK_OD_UNDEFINED_NOTIFY_UNREGISTER_CNF
 */

/* request packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_UNDEFINED_NOTIFY_UNREGISTER_REQ_T;

/* confirmation packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_UNDEFINED_NOTIFY_UNREGISTER_CNF_T;

/******************************************************************************
 * Packet EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_IND/EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_IND_DATA_Ttag
{
  TLR_UINT16              usIndex;
  TLR_UINT8               bSubIdx;
} __TLR_PACKED_POST EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_IND_DATA_T;

typedef struct EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_IND_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_IND_DATA_T  tData;
} EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_IND_T;

/* response packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_UNREGISTER_READ_PREPARE_RES_DATA_Ttag
{
  TLR_UINT16            usDataType;
  TLR_UINT16            usFieldLength;
} __TLR_PACKED_POST EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_RES_DATA_T;

typedef struct EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_RES_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_RES_DATA_T  tData;
} EPLCN_PCK_OD_UNDEFINED_READ_PREPARE_RES_T;


/******************************************************************************
 * Packet EPLCN_PCK_OD_UNDEFINED_READ_DATA_IND/EPLCN_PCK_OD_UNDEFINED_READ_DATA_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_UNDEFINED_READ_DATA_IND_DATA_Ttag
{
  TLR_UINT16                usIndex;
  TLR_UINT8                 bSubIdx;
  TLR_UINT32                ulExpectedDataSize; /* in bytes */
} __TLR_PACKED_POST EPLCN_PCK_OD_UNDEFINED_READ_DATA_IND_DATA_T;

typedef struct EPLCN_PCK_OD_UNDEFINED_READ_DATA_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  EPLCN_PCK_OD_UNDEFINED_READ_DATA_IND_DATA_T       tData;
} EPLCN_PCK_OD_UNDEFINED_READ_DATA_IND_T;

/* response packet */
#define EPLCN_PCK_OD_UNDEFINED_READ_DATA_MAX_BUFFER_SIZE 2048

typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_UNDEFINED_READ_DATA_RES_DATA_Ttag
{
  TLR_UINT8                 abData[EPLCN_PCK_OD_UNDEFINED_READ_DATA_MAX_BUFFER_SIZE]; /* dynamic array (for all compilers this way is valid */
} __TLR_PACKED_POST EPLCN_PCK_OD_UNDEFINED_READ_DATA_RES_DATA_T;

typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_UNDEFINED_READ_DATA_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  EPLCN_PCK_OD_UNDEFINED_READ_DATA_RES_DATA_T       tData;
} __TLR_PACKED_POST EPLCN_PCK_OD_UNDEFINED_READ_DATA_RES_T;

/******************************************************************************
 * Packet EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_IND/EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_IND_DATA_Ttag
{
  TLR_UINT16                  usIndex;
  TLR_UINT8                   bSubIdx;
  /* actual data follows here */
} __TLR_PACKED_POST EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_IND_DATA_T;

typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_IND_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_IND_DATA_T          tData;
} __TLR_PACKED_POST EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_IND_T;


#define EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_MAX_BUFFER_SIZE 2048

/* response packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_UNDEFINED_WRITE_DATA_RES_T;


/******************************************************************************
 * Packet EPLCN_PCK_OD_WRITE_OBJECT_REQ/EPLCN_PCK_OD_WRITE_OBJECT_CNF
 */

/* request packet */
#define EPLCN_PCK_OD_WRITE_OBJECT_MAX_DATA_SIZE 2048

typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_WRITE_OBJECT_REQ_DATA_Ttag
{
  TLR_UINT16                  usIndex;
  TLR_UINT8                   bSubIdx;

  /* data follows here */
} __TLR_PACKED_POST EPLCN_PCK_OD_WRITE_OBJECT_REQ_DATA_T;

typedef struct EPLCN_PCK_OD_WRITE_OBJECT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  EPLCN_PCK_OD_WRITE_OBJECT_REQ_DATA_T  tData;
} EPLCN_PCK_OD_WRITE_OBJECT_REQ_T;


/* confirmation packet */
typedef TLR_EMPTY_PACKET_T EPLCN_PCK_OD_WRITE_OBJECT_CNF_T;


/******************************************************************************
 * Packet EPLCN_PCK_OD_READ_OBJECT_REQ/EPLCN_PCK_OD_READ_OBJECT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct EPLCN_PCK_OD_READ_OBJECT_REQ_DATA_Ttag
{
  TLR_UINT16                  usIndex;
  TLR_UINT8                   bSubIdx;
} __TLR_PACKED_POST EPLCN_PCK_OD_READ_OBJECT_REQ_DATA_T;

typedef struct EPLCN_PCK_OD_READ_OBJECT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  EPLCN_PCK_OD_READ_OBJECT_REQ_DATA_T   tData;
} EPLCN_PCK_OD_READ_OBJECT_REQ_T;

/* confirmation packet */
typedef struct EPLCN_PCK_OD_READ_OBJECT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;

  /* data follows here */
} EPLCN_PCK_OD_READ_OBJECT_CNF_T;

#define EPLCN_PCK_OD_READ_OBJECT_MAX_DATA_SIZE 2048

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(EPLCNPCK_PUBLIC)
#endif

#endif // EPLCNPI_PUBLIC_H_INCLUDED

/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Filename:
    $Workfile: EplCnDpm_Public.h $
   Last Modification:
    $Author: Sven $
    $Modtime: 16.04.08 10:30 $
    $Revision: 2 $

   Targets:

   Description:



  Functions:


   Changes:

     Version    Date        Author   Description
     ---------------------------------------------------------------------------
    1           11.10.2007  SB        created
*******************************************************************************/

#ifndef EPLCNDPM_PUBLIC_H_INCLUDED
#define EPLCNDPM_PUBLIC_H_INCLUDED

#ifndef __EPLCN_DPM_PACKED_PRE
#define __EPLCN_DPM_PACKED_PRE  __TLR_PACKED_PRE
#endif
#ifndef __EPLCN_DPM_PACKED_POST
#define __EPLCN_DPM_PACKED_POST  __TLR_PACKED_POST
#endif

/***************************************************************************************/
/* EplCn Pck public, constants */

#define EPLCN_DPM_PROCESS_QUEUE_NAME       "QUE_EPLCN_DPM"

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(EPLCNPCK_PUBLIC)
#endif


typedef __EPLCN_DPM_PACKED_PRE struct EPLCN_DPM_EXTENDED_STATUS_DATA_Ttag
{
  TLR_UINT8     bNodeId;
  TLR_UINT8     bNmtStatus;
  TLR_UINT16    usNmtErrorProfile;
  TLR_UINT16    usNmtError;
  TLR_STR       abNmtStatusAscii[7];
  TLR_UINT8     bInternalState;
  TLR_STR       abNmtErrAscii[8];
  TLR_STR       abErrInfoAscii[4];
  TLR_UINT16    usReserved;
  TLR_UINT32    ulValidDpmInputExchangesToPResOnSoC;
  TLR_UINT32    ulBlockedDpmInputExchangesToPResOnSoC;
  TLR_UINT32    ulValidDpmOutputExchangesOnPReqReceive;
  TLR_UINT32    ulBlockedDpmOutputExchangesOnPReqReceive;
  TLR_UINT32    ulDpmInputExchangesToPResOnInputCallback;
  TLR_UINT32    ulDpmOutputExchangesFromPReqOnOutputCallback;

  TLR_UINT32    ulIncompatibleMappingCounter;
  TLR_UINT32    ulUnexpectedEndOfPdoCounter;

  TLR_UINT32    ulStateChangesDueSoCLoss;
  TLR_UINT32    ulStateChangesDueSoCJitter;
  TLR_UINT32    ulStateChangesDuePReqLoss;
  TLR_UINT32    ulStateChangesDueSoALoss;
  TLR_UINT32    ulStateChangesDueCollision;
  TLR_UINT32    ulStateChangesDueCrcError;
  TLR_UINT32    ulStateChangesDueBusOff;
  TLR_UINT32    ulPResBufferExchangeFailures;
  TLR_UINT32    ulWatchdogErrorsOccured;
  TLR_UINT32    ulMarker;
  TLR_UINT16    usActPResSize;
  TLR_UINT8     bFirstPResDone;
} __EPLCN_DPM_PACKED_POST EPLCN_DPM_EXTENDED_STATUS_DATA_T;


/******************************************************************************
 * Profile Error Codes:  usProfile == 0x001
 *  used for DPM firmwares
 */
#define EPLCN_E_VENDOR_HOST_NOT_READY               0x8000
#define EPLCN_E_VENDOR_HOST_WATCHDOG_TIMEOUT        0x8001
#define EPLCN_E_VENDOR_HOST_CHANNEL_RESET_DETECTED  0x8002
#define EPLCN_E_VENDOR_STACK_NOT_CONFIGURED         0x8003




#define EPLCN_DPM_CHANGE_MAP_VERS_REQ               0x13E0
#define EPLCN_DPM_CHANGE_MAP_VERS_CNF               0x13E1


#define EPLCN_DPM_SET_NODE_ID_REQ                   0x13E2
#define EPLCN_DPM_SET_NODE_ID_CNF                   0x13E3


/******************************************************************************
 * Request Packet:  EPLCN_DPM_CHANGE_MAP_VERS_REQ
 */
typedef __TLR_PACKED_PRE struct EPLCN_DPM_CHANGE_MAP_VERS_REQ_DATA_Ttag
{
  /* PReq mapping version */
  TLR_UINT8       bPReqMappingVersion;
  /* PRes mapping version */
  TLR_UINT8       bPResMappingVersion;
  /* Check for PReq mapping version */
  TLR_BOOLEAN8    fCheckPReqMappingVersion;
} __TLR_PACKED_POST EPLCN_DPM_CHANGE_MAP_VERS_REQ_DATA_T;

typedef struct EPLCN_DPM_CHANGE_MAP_VERS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  EPLCN_DPM_CHANGE_MAP_VERS_REQ_DATA_T  tData;
} EPLCN_DPM_CHANGE_MAP_VERS_REQ_T;

typedef TLR_EMPTY_PACKET_T EPLCN_DPM_CHANGE_MAP_VERS_CNF_T;


/******************************************************************************
 * Packet:  EPLCN_DPM_SET_NODE_ID_REQ/EPLCN_DPM_SET_NODE_ID_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct EPLCN_DPM_SET_NODE_ID_REQ_DATA_Ttag
{
  TLR_UINT8       bNodeId;
} __TLR_PACKED_POST EPLCN_DPM_SET_NODE_ID_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct EPLCN_DPM_SET_NODE_ID_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  EPLCN_DPM_SET_NODE_ID_REQ_DATA_T      tData;
} __TLR_PACKED_POST EPLCN_DPM_SET_NODE_ID_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct EPLCN_DPM_SET_NODE_ID_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
} __TLR_PACKED_POST EPLCN_DPM_SET_NODE_ID_CNF_T;


/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(EPLCNPCK_PUBLIC)
#endif


#endif // EPLCNDPM_PUBLIC_H_INCLUDED
